#include "dialog.h"
#include "ui_dialog.h"
#include<QtGui>

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);

    ui->label->setText("<b>What's your <font color=red> choice? </font></b>");
    hide_options();
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::on_pushButton_clicked()
{
     int res = QMessageBox::information(this,"Option", "Want to choose " + item + "?",QMessageBox::Yes | QMessageBox::No );
     switch(res)
     {
        case QMessageBox::Yes:
         ui->label_2->setText("You have chosen " + item);
         break;
        case QMessageBox::No:
         ui->label_2->setText("You haven't made any choice.");
            break;
     }
}

void Dialog::on_radioButton_clicked(bool checked)
{
    if(checked)
        item = ui->radioButton->text();
}

void Dialog::on_radioButton_2_clicked(bool checked)
{
    item = ui->radioButton_2->text();
}

void Dialog::on_radioButton_3_clicked(bool checked)
{
    item = ui->radioButton_3->text();
}

void Dialog::on_checkBox_clicked(bool checked)
{
    if(checked)
    {
        show_options();
    }
    else
    {
        hide_options();
    }
}

void Dialog::hide_options()
{
    ui->radioButton->hide();
    ui->radioButton_2->hide();
    ui->radioButton_3->hide();
    ui->label->hide();
    ui->label_2->hide();
}

void Dialog::show_options()
{
    ui->radioButton->show();
    ui->radioButton_2->show();
    ui->radioButton_3->show();
    ui->label->show();
    ui->label_2->show();
    ui->label_2->clear();
}
