
#include <stdio.h>

/* This function determines the OS data model used,
   32 bit GNU/Linux uses ILP32,
   64 bit GNU/Linux uses LP64.
*/ 
int dataModel(int *piILP32, int *piLP64, int iVerbose) {

    if(!piILP32 || !piLP64)
        return 0;

    *piILP32 = *piLP64 = 0;

    if(sizeof(int) == sizeof(long)) {

        *piILP32 = 1;
        if(iVerbose)
            printf("\n GNU/Linux data model is ILP32.\n");

    }
    else {

        *piLP64 = 1;
        if(iVerbose)
            printf("\n GNU/Linux data model is LP64.\n");

    }

    return 1;

}
