#! /usr/bin/env python

from ctypes import *

def dataModel(dDataModel, bVerbose = True):
    '''
        A python wrapper over the shared library C function.
    '''

    iILP32 = c_int()
    iLP64  = c_int()

    slib   = 'testlib.so'

    hlib   = CDLL(slib)

    ir     = 0
    if bVerbose:
        ir = hlib.dataModel(byref(iILP32), byref(iLP64), 1)
    else:
        ir = hlib.dataModel(byref(iILP32), byref(iLP64), 0)

    if ir:
        dDataModel['ILP32'] = iILP32.value
        dDataModel['LP64' ] = iLP64.value 

    return ir


# main application routine.
if '__main__' == __name__:

    dDataModel = {}
    
    print(' Verbose mode =>')
    if(dataModel(dDataModel)):
        print(' dDataModel : ' + str(dDataModel))
 
    print
    
    print(' Non verbose mode =>')
    if(dataModel(dDataModel, False)):
        print
        print(' dDataModel : ' + str(dDataModel))
